% this handles the "CMA Surface" action for the BERGulator

% Copyright 1997-1998 Phil Schniter

 % keep all variables local in scope
 function [] = ui_surf();

 % declare global variables
 berg_global; ui_private_global;

 % print text message and lock menu
 set(h_msg,'FontAngle','italic', 'String','calculating surface...'); 
 set(fig_menu,'HandleVisibility','off'); drawnow;

 % clear objects on surface 
 surf_exists = 0; 
 if (ishandle(fig_surf)), 		% check if marker on surface
   if ~isempty(h_trace_f),
     if min(ishandle(h_trace_f)), surf_exists = 1; end;
   end;
   if ~isempty(h_trace_i),
     if min(ishandle(h_trace_i)), surf_exists = 1; end;
   end;
 end;
 figure(fig_surf);
 set(fig_surf, 'DeleteFcn','ui_del_surf');
 if ishandle(h_trace_c), delete(h_trace_c); end;
 if ishandle(h_trace_b), delete(h_trace_b); end; h_trace_b = [];
 if ishandle(h_trace_t), delete(h_trace_t); end; h_trace_t = [];

 % invoke CMA surface plotting routines
 if surf_exists, hold on; zoom off; end;
 if alg_surf,	% algorithm-specific integrated error-function 
   % calculate godard radii for DSE-CMA
   if dse_alpha ~= dse_alpha_old,
     if real_source,			% PAM
       dse_gamma = calc_dsegamma_PAM(dse_alpha,alphabet,kappa);
     else,				% QAM
       dse_gamma = calc_dsegamma_QAM(dse_alpha,alphabet,kappa);
     end
     dse_alpha_old = dse_alpha;
   end
   h_trace_c = gensurf_eq(C,F,diag(E),kappa,sigma2_n,delta_opt,origin,...
	ranges,alphabet,se_gamma,dse_gamma,ncma_alpha,get(h_alg,'Value'),N_v);
 else		% CMA 2-2 only, directly calculated
   h_trace_c = cmasurf_eq(C,F,diag(E),kappa,sigma2_n,delta_opt,origin,...
	ranges,real_source,real_noise,N_v);
 end;
 hold off;
 if get(h_axes,'Value'),
   figure(fig_surf);
   axis('equal');
 end
 zoom on;

 % clear text message, unlock menu, enable facets, dim spike
 set(fig_menu,'HandleVisibility','on'); drawnow;
 set(h_msg,'FontAngle','normal', 'String','');
 if real_source, 
   set(h_sign, 'String','Sign Boundaries', 'Enable','on'); 
   set(h_spike, 'Enable','off'); 
 end;
