% this re-smooths the CME history for the BERGulator

% Copyright 1997-1998 Phil Schniter

 % keep all variables local in scope
 function [] = ui_smooth();
 
 % declare global variables
 berg_global; ui_private_global;

 % leave if nothing to do
 if isempty(h_trace_h), return; 
 elseif ~min(ishandle(h_trace_h)), return; end;

 % delete invalid history trace 
 delete(h_trace_h(length(h_trace_h)-1));

 % re-smooth CME history
 [filt_num,filt_den] = butter(1,10^(-get(h_smooth,'Value')));
 cme_filt = 10*log10(abs(filtfilt(filt_num,filt_den,...         % CME 
        srcme(1:floor((N-N_h)/D_e)+1).^2)));

 % plot new history trace
 figure(fig_hist); subplot(211);
 axe1 = axis;                         	% retain old axis properties
 hold on;				% dont clobber other traces
 h_trace_h(length(h_trace_h)-1) = plot([0:length(cme_filt)-1]*D_e,cme_filt);
 hold off;

 % apply new axes
 axis([0,N_max,min([axe1(3),cme_filt-3]),max([axe1(4),cme_filt+3])]);

 % set color
 tmp_colr = get(h_trace_h(length(h_trace_h)),'Color');	% from mse trace
 set(h_trace_h(length(h_trace_h)-1),'Color',tmp_colr);	% ...match color
 
