% this handles the plotting of M-PAM sign boundaries for the BERGulator

% Copyright 1997-1998 Phil Schniter

 % keep all variables local in scope
 function [] = ui_sign();

 % declare global variables
 berg_global; ui_private_global;
 
 if ishandle(h_trace_b),	% M-PAM sign boundaries exist
   ui_grad;			% ...so determine sign gradient
 else,				% create M-PAM sign boundaries
   % exhaustively determine regressors
    S = zeros(M_s^N_h,N_h);      % every possible input
    for i=1:N_h,
      S(:,i) = alphabet(rem(floor([0:M_s^N_h-1]/M_s^(N_h-i)),M_s)+1).';
    end
    SC = S*C;            % a list of every possible regressor
   % plot sign boundaries
    f_sgn0 = [-ranges(1);ranges(1)];
    set(h_msg,'FontAngle','italic', 'String','calculating boundaries...');
    set(fig_menu,'HandleVisibility','off'); drawnow;
    figure(fig_surf);
    hold on;
    for i=1:M_s^N_h,
     for k =-1:1, 		% sign boundary triplet
       if SC(i,2)==0, SCi2 = eps; else, SCi2 = SC(i,2); end;
       f_sgn1 = (sqrt(se_gamma)*k-f_sgn0*SC(i,1))/SCi2;
       h_trace_b = [h_trace_b, plot(f_sgn0,f_sgn1,'g')];	
     end
    end
    hold off;
    set(h_msg,'FontAngle','normal', 'String','');
    set(fig_menu,'HandleVisibility','on'); drawnow;
   % change sign button now that facets are available
    set(h_sign, 'String','Facet Gradient');
 end

 % enable trace clearing
 set(h_clr, 'Enable','on');
