% this handles the "Impulse Response" action for the BERGulator

% Copyright 1997-1998 Phil Schniter

 % keep all variables local in scope
 function [] = ui_imp();

 % declare global variables
 berg_global; ui_private_global;

 % input test_equalizer if exists 
 if ishandle(h_trace_i), imps_exist = 1; else, imps_exist = 0; end;
 if ishandle(h_trace_c) & real_source,
   set(h_msg,'BackgroundColor',[0 1 0]);		% print message
   set(h_msg,'FontAngle','italic', 'String','click on surface...'); drawnow;
   figure(fig_surf);
   zoom off; f_imp = ginput(1).'; zoom on;		% get eqlzer directly
   hold on; h_trace_new = plot(f_imp(1),f_imp(2),'d'); hold off;
   set(h_trace_new,'Color',colr); drawnow; h_trace_i = [h_trace_i,h_trace_new];
   set(h_msg,'BackgroundColor',[.8 .8 .8]);		% clear message
   set(h_msg, 'FontAngle','normal', 'String',''); drawnow;
   test_equalizer = 1;
 elseif (ishandle(h_trace_tt))&(N_f == length(f(:,1))),	
   set(h_msg,'BackgroundColor',[0 1 0]);		% print message
   set(h_msg,'FontAngle','italic', 'String','click on tap-hist...'); drawnow;
   figure(fig_taps);
   zoom off; [N_imp,dum] = ginput(1); zoom on;		% get x location
   N_imp = floor(N_imp/D_f)+1;				% ...and thus iter #
   while (N_imp > floor(N/D_f)+1)|(N_imp<1),
     err_string = ['Must choose 0 < index < ',num2str(N),'!'];
     disp(err_string);  
     zoom off; [N_imp,dum] = ginput(1); zoom on;
     N_imp = floor(N_imp/D_f)+1;
   end
   f_imp = f(:,N_imp);					% use tap history 
   subplot(211); hold on; 				% leave a marker
   h_trace_new = plot((D_f*(N_imp-1))*ones(N_f,1),real(f(:,N_imp)),'d'); 
   set(h_trace_new,'Color',colr); h_trace_tt = [h_trace_tt,h_trace_new];
   hold off; 
   subplot(212); hold on; 				% leave a marker
   h_trace_new = plot((D_f*(N_imp-1))*ones(N_f,1),imag(f(:,N_imp)),'d'); 
   set(h_trace_new,'Color',colr); h_trace_tt = [h_trace_tt,h_trace_new];
   hold off; 
   set(h_msg,'BackgroundColor',[.8 .8 .8]);		% remove message
   set(h_msg, 'FontAngle','normal', 'String',''); drawnow;
   test_equalizer = 1;
 else,
   test_equalizer = 0;
 end; 

 % remember old axes
 figure(fig_imp);
 edge = 0.1;
 if imps_exist,
   subplot(323); axe1 = axis;
   subplot(324); axe2 = axis;
   subplot(325); axe3 = axis;
   subplot(326); axe4 = axis;
 else
   axe1 = [-0.05*(N_f-1),1.05*(N_f-1),Inf,-Inf];
   axe2 = [-0.05*(N_f-1),1.05*(N_f-1),Inf,-Inf];
   axe3 = [-0.05*(N_h-1),1.05*(N_h-1),Inf,-Inf];
   axe4 = [-0.05*(N_h-1),1.05*(N_h-1),Inf,-Inf];
 end

 % replot known impulse responses 
 if ishandle(h_trace_ii), delete(h_trace_ii); end; h_trace_ii=[];
 figure(fig_imp); 
 set(fig_imp, 'DeleteFcn','ui_del_imp');
 subplot(321); 				% ref channel 
   h_trace_ii = stmplot(real(c),'filled').';
 subplot(322); 
   h_trace_ii = [h_trace_ii,stmplot(imag(c),'filled').'];
 subplot(323); if imps_exist, hold on; end;	% ref equalizer 
   h_trace_ii = [h_trace_ii, stmplot(real(f_opt),'k:').']; hold off;
   axis([min(axe1(1),-0.05*(N_f-1)),max(axe1(2),1.05*(N_f-1)),...
     min(axe1(3),min(real(f_opt)-edge)),max(axe1(4),max(real(f_opt))+edge)]);
   axe1 = axis;
 subplot(324); if imps_exist, hold on; end;
   h_trace_ii = [h_trace_ii, stmplot(imag(f_opt),'k:').']; hold off;
   axis([min(axe2(1),-0.05*(N_f-1)),max(axe2(2),1.05*(N_f-1)),...
     min(axe2(3),min(imag(f_opt))-edge),max(axe2(4),max(imag(f_opt))+edge)]);
   axe2 = axis;
 subplot(325); if imps_exist, hold on; end; 	% ref system 
   h_trace_ii = [h_trace_ii, stmplot(real(h_glob),'k:').']; hold off;
   axis([min(axe3(1),-0.05*(N_h-1)),max(axe3(2),1.05*(N_h-1)),...
     min(axe3(3),min(real(h_glob))-edge),max(axe3(4),max(real(h_glob))+edge)]);
   axe3 = axis;
 subplot(326); if imps_exist, hold on; end;
   h_trace_ii = [h_trace_ii, stmplot(imag(h_glob),'k:').']; hold off;
   axis([min(axe4(1),-0.05*(N_h-1)),max(axe4(2),1.05*(N_h-1)),...
     min(axe4(3),min(imag(h_glob))-edge),max(axe4(4),max(imag(h_glob))+edge)]);
   axe4 = axis;

 if sim_ran, 			% calculate local MMSE system response
   h_loc = C*f_des;		
   if ishandle(h_trace_iii), delete(h_trace_iii); h_trace_iii = []; end;
   figure(fig_imp);
   subplot(323);		% locally optimum equalizer
     hold on; h_trace_iii = stmplot(real(f_des),'r--').'; hold off;
     axis([min(axe1(1),-0.05*(N_f-1)),max(axe1(2),1.05*(N_f-1)),...
       min(axe1(3),min(real(f_des))-edge),max(axe1(4),max(real(f_des))+edge)]);
     axe1 = axis;
   subplot(324);		% locally optimum equalizer
     hold on; h_trace_iii = [h_trace_iii,stmplot(imag(f_des),'r--').'];hold off;
     axis([min(axe2(1),-0.05*(N_f-1)),max(axe2(2),1.05*(N_f-1)),...
       min(axe2(3),min(real(f_des))-edge),max(axe2(4),max(real(f_des))+edge)]);
     axe2 = axis;
   subplot(325);		% locally optimum system
     hold on; h_trace_iii = [h_trace_iii,stmplot(real(h_loc),'r--').'];hold off;
     axis([min(axe3(1),-0.05*(N_h-1)),max(axe3(2),1.05*(N_h-1)),...
       min(axe3(3),min(real(h_loc))-edge),max(axe3(4),max(real(h_loc))+edge)]);
     axe3 = axis;
   subplot(326);		% locally optimum system
     hold on; h_trace_iii = [h_trace_iii,stmplot(imag(h_loc),'r--').'];hold off;
     axis([min(axe4(1),-0.05*(N_h-1)),max(axe4(2),1.05*(N_h-1)),...
       min(axe4(3),min(real(h_loc))-edge),max(axe4(4),max(real(h_loc))+edge)]);
     axe4 = axis;
 end;

 if test_equalizer,		% calculate and plot impulse responses
   h_imp = C*f_imp;
   figure(fig_imp);
   subplot(323);		% test equalizer
     hold on; h_trace_new = stmplot(real(f_imp),'*').'; hold off;
     set(h_trace_new,'Color',colr); h_trace_i = [h_trace_i,h_trace_new];
     axis([min(axe1(1),-0.05*(N_f-1)),max(axe1(2),1.05*(N_f-1)),...
	min(axe1(3),min(real(f_imp))-edge),max(axe1(4),max(real(f_imp))+edge)]);
     axe1 = axis;
   subplot(324);
     hold on; h_trace_new = stmplot(imag(f_imp),'*').'; hold off;
     set(h_trace_new,'Color',colr); h_trace_i = [h_trace_i,h_trace_new];
     axis([min(axe2(1),-0.05*(N_f-1)),max(axe2(2),1.05*(N_f-1)),...
	min(axe2(3),min(imag(f_imp))-edge),max(axe2(4),max(imag(f_imp))+edge)]);
     axe2 = axis;
   subplot(325);		% test system 
     hold on; h_trace_new = stmplot(real(h_imp),'*').'; hold off;
     set(h_trace_new,'Color',colr); h_trace_i = [h_trace_i,h_trace_new];
     axis([min(axe3(1),-0.05*(N_h-1)),max(axe3(2),1.05*(N_h-1)),...
	min(axe3(3),min(real(h_imp))-edge),max(axe3(4),max(real(h_imp))+edge)]);
     axe3 = axis;
   subplot(326);
     hold on; h_trace_new = stmplot(imag(h_imp),'*').'; hold off;
     set(h_trace_new,'Color',colr); h_trace_i = [h_trace_i,h_trace_new];
     axis([min(axe4(1),-0.05*(N_h-1)),max(axe4(2),1.05*(N_h-1)),...
	min(axe4(3),min(imag(h_imp))-edge),max(axe4(4),max(imag(h_imp))+edge)]);
     axe4 = axis;
 end

 % titles, legends, and overlay ref traces so they are visible 
 figure(fig_imp);
 subplot(321);
   ylabel('real'); title('Channel impulse response'); zoom on;
 subplot(322);
   ylabel('imag'); title('Channel impulse response'); zoom on;
 subplot(323);
   delete(h_trace_ii(5:6));		% dont want to accumulate these
   hold on;
   h_trace_ii(5:6) = stmplot(real(f_opt),'k:').';
   hold off;
   ylabel('real'); title('Equalizer impulse response');
   zoom on;
 subplot(324);
   delete(h_trace_ii(7:8));		% dont want to accumulate these
   hold on;
   h_trace_ii(7:8) = stmplot(imag(f_opt),'k:').';
   hold off;
   ylabel('imag'); title('Equalizer impulse response');
   if sim_ran & test_equalizer,
     legend([h_trace_i(length(h_trace_i)-5),h_trace_ii(7),h_trace_iii(3)],...
	'eq','eq_{mmse-glob}','eq_{mmse-loc}',4); 
   elseif test_equalizer,
     legend([h_trace_i(length(h_trace_i)-5),h_trace_ii(7)],...
	'eq','eq_{mmse-glob}',4); 
   elseif sim_ran,
     legend([h_trace_ii(7),h_trace_iii(3)],...
	'eq_{mmse-glob}','eq_{mmse-loc}',4); 
   else,
     legend(h_trace_ii(7),'eq_{mmse-glob}',4); 
   end
   zoom on;
 subplot(325);
   delete(h_trace_ii(9:10));		% dont want to accumulate these
   hold on;
   h_trace_ii(9:10) = stmplot(real(h_glob),'k:').';
   hold off;
   ylabel('real'); title('System impulse response');
   zoom on;
 subplot(326);
   delete(h_trace_ii(11:12));		% dont want to accumulate these
   hold on;
   h_trace_ii(11:12) = stmplot(imag(h_glob),'k:').';
   hold off;
   ylabel('imag'); title('System impulse response');
   if sim_ran & test_equalizer,
     legend([h_trace_i(length(h_trace_i)-1),h_trace_ii(11),h_trace_iii(3)],...
	'sys','sys_{mmse-glob}','sys_{mmse-loc}',4); 
   elseif test_equalizer,
     legend([h_trace_i(length(h_trace_i)-1),h_trace_ii(11)],...
	'sys','sys_{mmse-glob}',4); 
   elseif sim_ran,
     legend([h_trace_ii(11),h_trace_iii(3)],...
	'sys_{mmse-glob}','sys_{mmse-loc}',4); 
   else,
     legend(h_trace_ii(11),'sys_{mmse-glob}',4); 
   end
   zoom on;

 % enable clear command if necessary
 if sim_ran | test_equalizer, set(h_clr, 'Enable','on'); end;

