% this calculates the facet gradient for the BERGulator

% Copyright 1997-1998 Phil Schniter

 % keep all variables local in scope
 function [] = ui_grad();

 % declare global variables
 berg_global; ui_private_global;
 
 % escape if surface is missing or invalid, or if ui_sign.m has not been run
 if isempty(h_trace_c), error('You need a surface plot first!'); end;
 if ~min(ishandle(h_trace_c)), error('Invalid surface plot!'); end;
 if isempty(SC), error('SC undefined: run ui_sign.m first!'); end;

 % get location for computation of gradient (f_grad)
 set(h_msg,'BackgroundColor',[0 1 0]);
 set(h_msg,'FontAngle','italic', 'String','click on surface...'); drawnow;
 figure(fig_surf);
 zoom off; f_grad = ginput(1).'; zoom on;

 % calculate gradient using finite-alphabet property
 y_grad = SC*f_grad;				% every possible output
 motion = sum(SC.*(sign(y_grad.*(kappa-y_grad.^2))*ones(1,N_f)))/(M_s^N_h)/4;
 grad_mag = sqrt(motion*motion');
 if grad_mag < 10*eps, 
   grad_disp = 0; 
 else
   grad_disp = grad_mag; 
 end;	% get around numer precision

 % superimpose gradient on cost surface 
 figure(fig_surf);
 hold on;
 h_trace_b = [h_trace_b, plot([f_grad(1),f_grad(1)+motion(1)],...
	[f_grad(2),f_grad(2)+motion(2)],'r',f_grad(1),f_grad(2),'ro').'];
 hold off;

 % report gradient magnitude as text message
 set(h_msg,'BackgroundColor',[.8 .8 .8]);
 set(h_msg, 'FontAngle','normal', 'String','');
 set(h_msg2, 'String',['Gradient = ',num2str(grad_disp,3)]); drawnow;
