% this handles the BSE/FSE case for the BERGulator

% Copyright 1997-1998 Phil Schniter

 % keep all variables local in scope
 function [] = ui_fse();

 % declare global variables
 berg_global; ui_private_global;
 
 % base channel type on BSE/FSE choice
 if get(h_fse,'Value') == 1,	% ->FSE
   set(h_chan,'String','4-tap|6-tap|Custom|Read from file');
   if ~is_FSE,			% BSE->FSE
     if get(h_chan,'Value')==3, 
       set(h_chan,'Value',4);  % keep "read from file" 
     elseif get(h_chan,'Value')==2, 
       set(h_chan,'Value',3);  % keep "custom" 
     else,
       set(h_chan,'Value',3);  % other BSE channels become custom FSEs
     end;
   end;
 else				% ->BSE
   set(h_chan,'String','2-tap|Custom|Read from file');
   if is_FSE,			% FSE->BSE
     if get(h_chan,'Value')==4,
       set(h_chan,'Value',3); 	% keep "read from file" 
     elseif get(h_chan,'Value')==3, 
       set(h_chan,'Value',2); 	% keep "custom" 
     else,
       set(h_chan,'Value',2); 	% other FSE channels become custom BSEs
     end;
   end;
 end;

 % remember last setting of FSE/BSE
 is_FSE = 2-get(h_fse,'Value');

 % enforce possible changes to channel type (and thus coefficients)
 ui_chan;
