% this handles the "Freq Response" action for the BERGulator

% Copyright 1997-1998 Phil Schniter

 % keep all variables local in scope
 function [] = ui_freq();

 % declare global variables
 berg_global; ui_private_global;

 % enable clear command
 set(h_clr, 'Enable','on');

 % input test_equalizer if exists 
 if ishandle(h_trace_f), frqs_exist = 1; else, frqs_exist = 0; end;
 if ishandle(h_trace_c) & real_source,
   set(h_msg,'BackgroundColor',[0 1 0]);		% print message
   set(h_msg,'FontAngle','italic', 'String','click on surface...'); drawnow;
   figure(fig_surf);
   zoom off; f_freq = ginput(1).'; zoom on;		% get eqlzer directly
   hold on; h_trace_new = plot(f_freq(1),f_freq(2),'o'); hold off;
   set(h_trace_new,'Color',colr); drawnow; h_trace_f = [h_trace_f,h_trace_new];
   set(h_msg,'BackgroundColor',[.8 .8 .8]);		% clear message
   set(h_msg, 'FontAngle','normal', 'String',''); drawnow;
   test_equalizer = 1;
 elseif (ishandle(h_trace_tt))&(N_f == length(f(:,1))),	
   set(h_msg,'BackgroundColor',[0 1 0]);		% print message
   set(h_msg,'FontAngle','italic', 'String','click on tap-hist...'); drawnow;
   figure(fig_taps);
   zoom off; [N_freq,dum] = ginput(1); zoom on;		% get x location
   N_freq = floor(N_freq/D_f)+1;			% ...and thus iter #
   while (N_freq > floor(N/D_f)+1)|(N_freq<1),
     err_string = ['Must choose 0 < index < ',num2str(N),'!'];
     disp(err_string);  
     zoom off; [N_freq,dum] = ginput(1); zoom on;
     N_freq = floor(N_freq/D_f)+1;
   end
   f_freq = f(:,N_freq);				% use tap history 
   subplot(211); hold on; 				% leave a marker
   h_trace_new = plot((D_f*(N_freq-1))*ones(N_f,1),real(f(:,N_freq)),'o'); 
   set(h_trace_new,'Color',colr); h_trace_tt = [h_trace_tt,h_trace_new];
   hold off; 
   subplot(212); hold on; 				% leave a marker
   h_trace_new = plot((D_f*(N_freq-1))*ones(N_f,1),imag(f(:,N_freq)),'o'); 
   set(h_trace_new,'Color',colr); h_trace_tt = [h_trace_tt,h_trace_new];
   hold off; 
   set(h_msg,'BackgroundColor',[.8 .8 .8]);		% remove message
   set(h_msg, 'FontAngle','normal', 'String',''); drawnow;
   test_equalizer = 1;
 else,
   test_equalizer = 0;
 end; 


 % calculate known frequency responses
 N_fft = 256;
 C_freq = 20*log10(abs(fftshift(fft(c,N_fft)))+eps);
 F_opt = 20*log10(abs(fftshift(fft(f_opt,N_fft)))+eps);
 H_opt = 20*log10(abs(fftshift(fft(C*f_opt,N_fft)))+eps);

 % avoid matlab idiosynchrocies
 if max(abs(H_opt))<1e-10, H_opt = zeros(size(H_opt)); end;	
 if max(abs(F_opt))<1e-10, F_opt = zeros(size(F_opt)); end;	
 if max(abs(C_freq))<1e-10, C_freq = zeros(size(C_freq)); end;	
 if (length(H_opt)==1)&(N_fft~=1), H_opt = H_opt*ones(1,N_fft); end;

 % replot known frequency responses only if necessary
 if (isempty(h_trace_ff))|(min(ishandle(h_trace_ff))==0),
   figure(fig_freq); 
   set(fig_freq, 'DeleteFcn','ui_del_freq');
   subplot(211);		% channel response (possible FS)
     if frqs_exist, hold on; end; 
     h_trace_ff = plot([-N_fft/2:N_fft/2-1]/N_fft*(1+is_FSE),C_freq,'b-.');
     hold off;
   subplot(212);		% optimal system (definitely BS)
   % this is really a dummy trace, but it makes things easier...
     if frqs_exist, hold on; end;
     h_trace_ff = [h_trace_ff, plot([-N_fft/2:N_fft/2-1]/N_fft,H_opt,'k--')];
     hold off;
 end

 if test_equalizer,		% calculate and plot frequency responses
   F_freq = 20*log10(abs(fftshift(fft(f_freq,N_fft)))+eps);
   H_freq = 20*log10(abs(fftshift(fft(C*f_freq,N_fft)))+eps);
   % fix matlab idiosynchracies...
   if (length(H_freq)==1)&(N_fft~=1), H_freq = H_freq*ones(1,N_fft); end;
   figure(fig_freq);
   subplot(211);		% test equalizer (possible FS)
     hold on;
     h_trace_new = plot([-N_fft/2:N_fft/2-1]/N_fft*(1+is_FSE),F_freq);
     set(h_trace_new,'Color',colr); h_trace_f = [h_trace_f,h_trace_new];
     hold off;
     %legend refresh done later...
   subplot(212);		% test system (definitely BS)
     hold on;
     h_trace_new = plot([-N_fft/2:N_fft/2-1]/N_fft,H_freq);
     set(h_trace_new,'Color',colr); h_trace_f = [h_trace_f,h_trace_new];
     hold off;
 end

 if sim_ran,
   F_des = 20*log10(abs(fftshift(fft(f_des,N_fft)))+eps);	% local soln
   H_des = 20*log10(abs(fftshift(fft(C*f_des,N_fft)))+eps);	% local soln
   % fix matlab idiosynchracies...
   if max(abs(H_des))<1e-10, H_des = zeros(size(H_des)); end;	
   if (length(H_des)==1)&(N_fft~=1), H_des = H_des*ones(1,N_fft); end;
   if ishandle(h_trace_fff), delete(h_trace_fff); h_trace_fff = []; end;
 end

 % overlay dashed traces (redoing the BS system trace) so they are visible 
 figure(fig_freq);
 subplot(211);
   delete(h_trace_ff(2));		% dont want to accumulate these
   hold on;
   if sim_ran,
     h_trace_fff = plot([-N_fft/2:N_fft/2-1]/N_fft*(1+is_FSE),F_des,'r--');
   end
   h_trace_ff(2)=plot([-N_fft/2:N_fft/2-1]/N_fft*(1+is_FSE),F_opt,'k--');
   hold off;
   ylabel('dB'); xlabel('normalized to baud frequency');
   title('Channel, equalizer frequency response magnitudes');
   if sim_ran,
     legend([h_trace_ff(1:2),h_trace_fff],'channel',...
	'eq_{mmse-glob}','eq_{mmse-loc}'); 
   else
     legend(h_trace_ff([1,2]),'channel','eq_{mmse-glob}'); 
   end
   zoom on;
 subplot(212);
   if length(h_trace_ff)==3, 		% dont want to accumulate these
     delete(h_trace_ff(3)); h_trace_ff = h_trace_ff(1:2); 
   end;
   hold on; 
   if sim_ran,
     h_trace_fff = [h_trace_fff, plot([-N_fft/2:N_fft/2-1]/N_fft,H_des,'r--')];
   end
   h_trace_ff = [h_trace_ff,plot([-N_fft/2:N_fft/2-1]/N_fft,H_opt,'k--')];
   hold off;
   ylabel('dB'); xlabel('normalized to baud frequency');
   title('System frequency response magnitude');
   if sim_ran,
     legend([h_trace_ff(3),h_trace_fff(2)],'sys_{mmse-glob}','sys_{mmse-loc}');
   else
     legend(h_trace_ff(3),'sys_{mmse-glob}');
   end
   zoom on;
