% this handles the deletion of the surface figure for the BERGulator

% Copyright 1997-1998 Phil Schniter

 % keep all variables local in scope
 function [] = ui_del_surf();

 % declare global variables
 berg_global; ui_private_global;
 
 % delete all contour traces
 for i=1:length(h_trace_c),
   if ishandle(h_trace_c(i)), delete(h_trace_c(i)); end;
 end;
 h_trace_c = [];

 % delete sign boundaries
 for i=1:length(h_trace_b),
   if ishandle(h_trace_b(i)), delete(h_trace_b(i)); end;
 end;
 h_trace_b = [];

 % delete all surface trajectory traces
 for i=1:length(h_trace_t),
   if ishandle(h_trace_t(i)), delete(h_trace_t(i)); end;
 end;
 h_trace_t = [];

 cur_axes = get(fig_surf,'Children');

 % delete impulse response markers
 del_list = [];
 save_list = [];
 for i=1:length(h_trace_i),
   if get(h_trace_i(i),'Parent') == cur_axes(2),
     delete(h_trace_i(i));
   else 
     save_list = [save_list,i];
   end;
 end
 h_trace_i = h_trace_i(save_list);

 % delete freq response markers
 del_list = [];
 save_list = [];
 for i=1:length(h_trace_f),
   if get(h_trace_f(i),'Parent') == cur_axes(2),
     delete(h_trace_f(i));
   else 
     save_list = [save_list,i];
   end;
 end
 h_trace_f = h_trace_f(save_list);

 % invalidate surface-driven actions, but enable delay selection
 set(h_sign, 'String','Sign Boundaries', 'Enable','off');
 set(h_spike,'Enable','on')
