% this manipulates the channel impulse response taps for the BERGulator

% Copyright 1997-1998 Phil Schniter

 % keep all variables local in scope
 function [] = ui_chan();
 
 % declare global variables
 berg_global; ui_private_global;
 
 % the default filename for channel coefficients 
 default_fname = 'test_channel.mat';

 % handle the "channel type" setting
 read_from_file = 0;
 if get(h_fse,'Value') == 2, 
   if get(h_chan,'Value') == 1,	 		% default BSE
     set(h_coefs,'String','[ 1 0.5 ]');
     set(h_coefs,'Enable','inactive');
   elseif get(h_chan,'Value') == 2,		% custom BSE
     if ~isempty(findstr('.mat',get(h_coefs,'String'))),    
       set(h_coefs,'String','[ 1 0.5 ]');	% if was a filename
     end
     set(h_coefs,'Enable','on');	
   elseif get(h_chan,'Value') == 3,		% read from file... 
     fname = get(h_coefs,'String');
     if isempty(findstr('.mat',fname)),		% check if .mat file
       set(h_coefs,'String',default_fname);
       fname = default_fname;
     elseif length(fname)-findstr('.mat',fname) ~= 3, 
       set(h_coefs,'String',default_fname);
       fname = default_fname;
     end
     set(h_coefs,'Enable','on');	
     read_from_file = 1;
   end
 else,
   if get(h_chan,'Value') == 1,  		% 4-tap FSE
     set(h_coefs,'String','[ 0.2 0.5 1 -0.1 ]');
     set(h_coefs,'Enable','inactive');
   elseif get(h_chan,'Value') == 2,  		% 6-tap FSE
     set(h_coefs,'String','[ 0.1 0.3 1 -0.1 0.5 0.2 ]');
     set(h_coefs,'Enable','inactive');
   elseif get(h_chan,'Value') == 3,		% custom FSE
     if ~isempty(findstr('.mat',get(h_coefs,'String'))),    
       set(h_coefs,'String','[ 1 0.5 ]');        % if was a filename
     end
     set(h_coefs,'Enable','on');
   elseif get(h_chan,'Value') == 4,		% read from file... 
     fname = get(h_coefs,'String');
     if isempty(findstr('.mat',fname)),		% check if .mat file
       set(h_coefs,'String',default_fname);
       fname = default_fname;
     elseif length(fname)-findstr('.mat',fname) ~= 3, 
       set(h_coefs,'String',default_fname);
       fname = default_fname;
     end
     set(h_coefs,'Enable','on');
     read_from_file = 1;
   end
 end; 

 % read in channel taps
 if read_from_file,
   err_string1 = ['File "',fname,'" doesnt exist!'];
   err_string2 = ['File "',fname,'" doesnt contain required variable "c"!'];
   % attempt to load "fname"...
   eval(['load ',fname,' c'],'error(err_string1)');
   % checking existence of "c" variable in "fname"...
   who_c = who('-file',fname,'c');
   if isempty(who_c), error(err_string2); end;
 else
   c = str2num(get(h_coefs,'String')); 		% get numeric coefficients
 end;
 if length(c) < 2,
   error('must have at least two channel coefficients');
 elseif min(size(c)) ~= 1,
   error('Channel must be an FIR vector');
 end
 c=c(:);
 N_c = length(c);   

 % normalize channel
 if get(h_norm,'Value'),
   c = c/norm(c);
 end

 % propagate change through the rest of parameters (e.g. delay selection)
 ui_calc_params;
