% this reads ui and sets global parameters for the BERGulator
 
% Copyright 1997-1998 Phil Schniter

 % keep all variables local in scope
 function [] = ui_calc_params();
 
 % declare global variables
 berg_global; ui_private_global;

 % get trace color
 ui_color;

 % get remaining channel params
 SNR = str2num(get(h_SNR,'String'));
 if (~isreal(SNR))|(max(size(SNR)) ~= 1),
   error('SNR must be a real-valued scalar or "Inf"');
 elseif SNR == Inf, 
   SNR = 10000; 
 end

 % warn if this will take time
 set(h_msg,'FontAngle','italic', 'String','calculating parameters...'); drawnow;

 % process the channel parameters
 CC = convmtx(c,N_f);		% channel convolution matrix
 if is_FSE,
   if 2*floor(N_f/2)==N_f,  	% for even eq lengths...
     C = CC(2:2:N_c+N_f-1,:);   %   odd-sampled decimated FS chan conv matrix
   else				% for odd eq lengths...
     C = CC(1:2:N_c+N_f-1,:);   %   even-sampled decimated FS chan conv matrix
   end
 else
   C = CC;                      % keep BS chan conv matrix
 end
 N_h = length(C(:,1));
 sigma2_n = 10^(-SNR/10);
 Rxx = C'*C+sigma2_n*eye(N_f);	% regressor autocov mtx (for sigma2_s = 1)
 Rxx_inv = pinv(Rxx);
 E = eye(N_h) - abs(C*Rxx_inv*C'); 	% mse scaled correctly if sigma2_s = 1
 [mse_opt,delta_opt] = min(diag(E));	% MMSE delay choice
 if SNR > SNR_ok,			% prevent numerical difficulties...
   [dum,delta_opt] = min(diag(eye(N_h)...
	 - abs(C*pinv(C'*C+10^(-SNR_ok/10)*eye(N_f))*C'))); 
 end;
 F = Rxx_inv*C';			% equalizers

 % update delay widget
 spike = get(h_spike,'Value')-1;
 if spike > floor(N_f/(1+is_FSE))-1,
   spike = floor(N_f/(1+is_FSE))-1;     % invalid spike: reset to max 
 end
 delay_string = [];
 for i=0:floor(N_f/(1+is_FSE))-2,
   delay_string = [delay_string,num2str(i),'|'];
 end
 delay_string = [delay_string,num2str(floor(N_f/(1+is_FSE))-1)];
 set(h_spike, 'String',delay_string);
 set(h_spike, 'Value',spike+1);

 % remember old surface parameters 
 if isempty(f_opt)&isempty(ranges)&isempty(src_type),
   f_opt_old = NaN*ones(N_f,1);
   ranges_old = [NaN,NaN];
   src_type_old = NaN;
 else
   f_opt_old = f_opt;
   ranges_old = ranges;
   src_type_old = src_type;
 end

 % determine optimal equalizer and system response
 h_opt = zeros(N_h,1); h_opt(delta_opt)=1;
 f_opt = F*h_opt;		% (global) MMSE equalizer
 h_glob = C*f_opt;              % (global) MMSE system response
 ranges = 1.5*max(abs(F.')).';

 % clear message 
 set(h_msg,'FontAngle','normal', 'String',''); drawnow;

 % source parameters
 src_type = get(h_source, 'Value');
 switch src_type 
   case 1, M_s = 2;                     % BPSK
   case 2, M_s = 4;                     % 4-PAM
   case 3, M_s = 8;                     % 8-PAM
   case 4, M_s = 16;                    % 16-PAM
   case 5, M_s = 32;                    % 32-PAM
   case 6, M_s = 4;                     % QPSK
   case 7, M_s = 16;                    % 16-QAM
   case 8, M_s = 64;                    % 64-QAM
   case 9, M_s = 256;                   % 256-QAM
   case 10,M_s = 1024;                  % 1024-QAM
 end
 if src_type < 6,	% PAM
   real_source = 1;
   kappa = M_s/2*sum((1+2*[0:M_s/2-1]).^4)/(sum((1+2*[0:M_s/2-1]).^2))^2;
   alphabet = [-(M_s-1):2:(M_s-1)]/sqrt(2/M_s*sum((1+2*[0:M_s/2-1]).^2));
 else			% QAM
   real_source = 0;
   kappa = (7*M_s-13)/(M_s-1)/5;
   sqrt_M_s = sqrt(M_s);
   alphabet = (ones(sqrt_M_s,1)*[-(sqrt_M_s-1):2:(sqrt_M_s-1)] +...
	-j*[-(sqrt_M_s-1):2:(sqrt_M_s-1)]'*ones(1,sqrt_M_s))/...
	sqrt(sum(([1:2:sqrt_M_s-1]).^2)*4/sqrt_M_s);
 end

 % godard radii for SE-CMA, WSGA
 switch src_type 
   case 1, se_gamma = 1;		% BPSK
	   wsga_gamma = se_gamma;
   case 2, se_gamma = 1.8;  		% 4-PAM
	   wsga_gamma = se_gamma;
   case 3, se_gamma = 1.19047619047619;	% 8-PAM
	   wsga_gamma = se_gamma;
   case 4, se_gamma = 1.42352941176471;	% 16-PAM
	   wsga_gamma = se_gamma;
   case 5, se_gamma = 1.55131964809384;	% 32-PAM
	   wsga_gamma = se_gamma;
   case 6, se_gamma = 1;		% QPSK
	   wsga_gamma = se_gamma;
   case 7, se_gamma = 1;		% 16-QAM
	   wsga_gamma = se_gamma;
   case 8, se_gamma = 1.19047619047619;	% 64-QAM
	   wsga_gamma = se_gamma;
   case 9, se_gamma = 1.18823529411764;	% 256-QAM
	   wsga_gamma = se_gamma;
   case 10,se_gamma = 1.23460410557186;	% 1024-QAM
	   wsga_gamma = se_gamma;
 end
 % force ui_traj.m to recompute godard radius for DSE-CMA (dependent on alpha!)
 dse_alpha_old = 0;

 % real noise only when both {source,chan} are real!
 if real_source & isreal(c), real_noise = 1; else, real_noise = 0; end;

 % see if the channel or equalizer has changed significantly
 has_changed = 0;
 if (N_f ~= length(f_opt_old)),
   has_changed = 1;
 elseif (f_opt ~= f_opt_old)|(ranges ~= ranges_old)|(src_type ~= src_type_old),
   has_changed = 1;
 end

 % clear {surface,facets,mse-bound,2-D,trajectories} if needed 
 if has_changed,
   if ishandle(h_trace_c), delete(h_trace_c); end; h_trace_c = [];
   if ishandle(h_trace_b), delete(h_trace_b); end; h_trace_b = [];
   if ishandle(h_trace_mse), delete(h_trace_mse); end; h_trace_mse = [];
   if ishandle(h_trace_t), delete(h_trace_t); end; h_trace_t = [];
   if ishandle(h_trace_ff), delete(h_trace_ff); end; h_trace_ff = [];
   if ishandle(h_trace_fff), delete(h_trace_fff); end; h_trace_fff = [];
   if ishandle(h_trace_ii), delete(h_trace_ii); end; h_trace_ii = [];
   if ishandle(h_trace_iii), delete(h_trace_iii); end; h_trace_iii = [];
   set(h_msg2,'String','');
   set(h_sign, 'String','Sign Boundaries', 'Enable','off');
   set(h_spike, 'Enable','on');
   sim_ran = 0;
 end

 % enable spike selection if complex source
 if real_source & ishandle(h_trace_c),
   set(h_spike, 'Enable','off'); 
 else
   set(h_spike, 'Enable','on'); 
 end;

 % disable surface plotting if complex channel or long equalizer
 if isreal(c) & (N_f == 2), 
   set(h_surf, 'Enable','on'); 
 else
   set(h_surf, 'Enable','off'); 
   set(h_sign, 'Enable','off'); 
 end;
