%STMPLOT   "stem" plot for short records, noral plot for long records.
%   (including improvements over the crappy matlab5 stem plot).  Usage
%   is just like stem:
%
%   ----------------------------------
%
%   STEM(Y) plots the data sequence Y as stems from the x axis
%   terminated with circles for the data value.
%
%   STEM(X,Y) plots the data sequence Y at the values specfied
%   in X.
%
%   STEM(...,'filled') produces a stem plot with filled markers.
%
%   STEM(...,'LINESPEC') uses the linetype specifed for the stems and
%   markers.  See PLOT for possibilities.
%
%   H = STEM(...) returns a vector of line handles.
%
%   See also PLOT, BAR, STAIRS.

%   Copyright 1997-1998 Phil Schniter

function H = stmplot(n1,n2,n3)

 washold = ishold;	% check if hold was turned on
 N = length(n1);
 N_max = 32;

 edge = 0.05*(N-1);
 if nargin == 1,
   plot([-edge,N-1+edge],[0,0],'k'); hold on; 
   if N > N_max, 
     hh = plot([0:N-1],n1); hh = [hh;hh];
   else, 
     hh = stem([0:N-1],n1); 
   end;
   axe = axis;
   axis([-edge,N-1+edge,axe(3:4)]);
 elseif nargin ==2,
   if ischar(n2),
     plot([-edge,N-1+edge],[0,0],'k'); hold on; 
     if N > N_max, 
       if strcmp(n2,'filled'), n2 = '-'; end;
       if findstr(n2,':'), 
         ind=findstr(n2,':'); n2=n2([1:ind-1,ind+1:length(n2)]); 
       elseif findstr(n2,'*'), 
         ind=findstr(n2,'*'); n2=n2([1:ind-1,ind+1:length(n2)]); 
       end;
       hh = plot([0:N-1],n1,n2); hh = [hh;hh];
     else, 
       hh = stem([0:N-1],n1,n2);
     end
     axe = axis;
     axis([-edge,N-1+edge,axe(3:4)]);
   else
     plot(n1,zeros(1,N),'k'); hold on; 
     if N > N_max, 
       hh = plot(n1,n2); hh = [hh;hh];
     else, 
       hh = stem(n1,n2);
     end
   end
 elseif nargin ==3,
   plot(n1,zeros(1,N),'k'); hold on; 
   if N > N_max, 
     if strcmp(n3,'filled'), n3 = '-'; end;
     if findstr(n3,':'), 
       ind=findstr(n3,':'); n3=n3([1:ind-1,ind+1:length(n3)]); 
     elseif findstr(n3,'*'), 
       ind=findstr(n3,'*'); n3=n3([1:ind-1,ind+1:length(n3)]); 
     end;
     hh = plot(n1,n2,n3); hh = [hh;hh];
   else, 
     hh = stem(n1,n2,n3); 
   end;
 elseif nargin >3,
   error('Too many input arguments.');
 end
 
 if ~washold, hold off; end;

 if nargout > 0, H = hh; end;
