% make_qam(M,N_s,sigma)
% makes a sequence of N_s samples of M-QAM with variance sigma^2,
% where M is of the form 4*N^2 (for integer N).
 
% Copyright 1997-1998 Phil Schniter

function s = make_qam(M,N_s,sigma)

 % a convenient quantity
 N = sqrt(M/4);					% M = 4N^2

 % check if valid M (via checking if N is an integer)
 if N ~= floor(N),
   error('M must be of the form 4*N^2 for integer N'); 
 end

 % generate M-QAM with constellation points at +/-{1,3,5,7,etc.}
 s = 2*(floor(2*N*rand(1,N_s))-N+0.5) +...
   j*2*(floor(2*N*rand(1,N_s))-N+0.5);

 % adjust variance 
 var_cur = 2/N*sum((1+2*[0:N-1]).^2);		% current variance
 s = s*(sigma/sqrt(var_cur));
