% this chooses DSE-CMA gamma for the bergulator under uniform dither 
% and an M-PAM source
 
% Copyright 1997-1998 Phil Schniter

function gam_opt = calc_dsegamma_PAM(dse_alpha,alphabet,kappa);

 if ~isreal(alphabet), error('expecting REAL-valued alphabet!'); end;
 alf = alphabet(1:length(alphabet));
 M_a = length(alf);
 M = 10;

 % check if kappa will work
 if dse_alpha > max((abs(alf).^2-kappa).*alf),
   gam_opt = kappa;
   return;
 end;

 % estimate best gamma
 [gam,inds] = sort([kappa,linspace(0.98,2,2*M)]);
 [dum,kap_ind] = min(inds);
 J = zeros(size(gam));
 for i=1:length(gam),
   J(i) = sum( min(dse_alpha*ones(1,M_a),max(-dse_alpha*ones(1,M_a),...
	(alf.^2-gam(i)).*alf)).*alf );
 end;
 [J_opt,ind] = min(abs(J));
 gam_opt = gam(ind);
 J_kap = abs(J(kap_ind));

 %figure(7)
 %plot(gam,abs(J))

 % refine estimate
 for k=1:ceil(13/log10(M)),
   gam = linspace(gam_opt-1/M^k,gam_opt+1/M^k,2*M);
   J = zeros(size(gam));
   for i=1:length(gam),
     J(i)=sum(min(dse_alpha*ones(1,M_a),max(-dse_alpha*ones(1,M_a),...
	(alf.^2-gam(i)).*alf)).*alf);
   end;
   [J_opt,ind] = min(abs(J));
   gam_opt = gam(ind);
 end;

return

 % output results
 format long
 gam_opt
 kappa
 format short


 figure(7)
 hold on; plot(gam_opt,J_opt,'ro'); hold off;
 hold on; plot(kappa, abs(sum(min(dse_alpha*ones(1,M_a), ...
	max(-dse_alpha*ones(1,M_a),(alf.^2-kappa).*alf)...
	).*alf)),'gd'); hold off;
 zoom on; grid on;

 figure(8)
 x = [-2:0.001:2]; 
 plot(x,min(dse_alpha*ones(size(x)),max(-dse_alpha*ones(size(x)),...
	(x.^2-gam_opt).*x))); 
 hold on; 
 plot(alphabet,min(dse_alpha*ones(size(alphabet)),max(-dse_alpha*ones(...
	size(alphabet)),(alphabet.^2-gam_opt).*alphabet)),'ro'); 
 hold off;
 title('DSE-CMA error function for \gamma_{opt}')
 grid on;

