% berg_global.m
%
% This m-file declares important BERGulator variables to be global 
% in scope so that their values can be accessed by the workspace.
% IMPORTANT: DO NOT change any BERGulator global variables while the 
% BERGulator is running.  Doing so entices Mentor Man to get you 
% while you are sleeping (http://backhoe.ee.cornell.edu/~schniter/mentor.jpg).
%
% berg_global.m also makes available the handles to user-interface 
% widgets so that changes to the user interface can be automated by
% another m-file. (see matlab5's SET() and GET() functions, or consult
% the "Handle Graphics Objects" section in matlab5's Help Desk.)
% Changes to certain ui-parameters must be followed by a special 
% command so that the changes propagate to all necessary global 
% variables.  These commands are provided below, where appropriate.
% Finally, the user interface actions can be automated by calling a 
% particular function, as outlined below.
%
%
%
% ++++++++++++++++++++++++++++++++ 
% | Global Variables (read-only) |
% ++++++++++++++++++++++++++++++++ 
%
% user parameters
% ---------------
% c       - channel response vector 
% SNR     - signal-to-noise ratio (dB)
% mu      - CMA step-size
% N       - number of source symbols per simulation
% is_FSE  - set to 1 for FSE, or 0 for BSE
% dse_alpha - DSE-CMA dither amplitude (defaults to 1)
%
% calculated quantities
% ---------------------
% C       - (decimated) channel convolution matrix
% E       - matrix whos i'th diagonal elements is MMSE for system delay i
% F       - matrix whos i'th columns is the MMSE equalizers for system delay i
% Rxx     - regressor autocorrelation matrix
% kappa   - source (normalized) kurtosis (gaussian: kappa = 3)
% sigma2_n- noise variance
%
% ideal and optimal responses
% ---------------------------
% delta_opt - optimal (baud-spaced) system delay 
% f_opt   - globally MMSE equalizer response
% mse_opt - globally minimum MSE (i.e. that attained by f_opt)
% h_glob  - globally MMSE system reponse (i.e. that attained by f_opt)
% h_opt	  - zero-forcing system response associated with h_glob
%
% lengths
% -------
% N_c     - channel length
% N_f     - equalizer length
% N_h     - (baud-spaced) system response length
% M_s     - source alphabet size
%
% equalizer adaptation quantities 
% -------------------------------
% f_init  - equalizer initialization 
% f       - decimated equalizer history
% f_cur   - current equalizer (i.e. final equalizer when adaptation stops) 
% y       - equalizer output history 
% srcme   - sqrt(Godard 2-2 error) history
% cme_filt- smoothed Godard 2-2 error history (in dB)
% mserr   - MSE history
% mse_filt- MSE history (in dB)
% D_f     - factor of decimation inherent to {f, mserr, mse_filt} traces 
% D_e     - factor of decimation inherent to {y, srcme, cme_filt} traces 
% h_best  - final system response achieved through adaptation 
% h_des   - locally zero-forcing system resp, but phase-rotated as h_best
% f_des   - locally MMSE equalizer, phase_rotated as h_best
% mse_des - locally minimum MSE (i.e. that attained by f_des) 
% h_loc   - locally MMSE system response (i.e. that attained by f_des)
%
% sign-boundary parameters
% ------------------------
% alphabet - members of source alphabet, normalized to unit power
% S        - a matrix whose columns form the collection of all source vectors
% grad_mag - gradient magnitude (valid after facet gradient computed)
%
% BERGulator options
% ------------------
% no_traj_plots - disables trajectory-related plots when set nonzero
% alg_surf - algorithm-specific surface plots (via integrated error-fxns)
%
%
% ++++++++++++++++++++++++++ 
% | User Interface Handles |
% ++++++++++++++++++++++++++ 
%
% handles to figures
% ------------------
% fig_menu - main-menu figure
% fig_surf - cost-surface figure
% fig_freq - freq-resp figure
% fig_imp  - impulse-resp figure
% fig_hist - CMA/MSE-histories figure
% fig_scat - scatter plot figure
% fig_taps - tap-trajectory figure
%
% handles to user-interface parameters            (post-modification command)
% ------------------------------------            ---------------------------
% h_chan   - channel type                                   (ui_chan;)
% h_fse    - FSE or BSE                                     (ui_fse;)
% h_source - source type                                    (ui_calc_params;)
% h_coefs  - channel coefficients or .mat filename          (ui_chan;)
% h_SNR    - signal-to-noise ratio (dB)                     (ui_calc_params;)
% h_norm   - automatic channel normalization                (ui_chan;)
% h_axes   - equally scaled axes on surface plot            (ui_axes;)
% h_N_f	   - equalizer length                               (ui_N_f;)
% h_alg    - equalizer update algorithm                     --
% h_spike  - location of double-spike intialization         --
% h_num    - number of iterations (i.e. BS source symbols)  --
% h_col    - trace color                                    (ui_color;)
% h_step   - stepsize                                       --
% h_smooth - CM error trace smoothing                       --
%
% handles to user-interface buttons           (command for m-file automation)
% ---------------------------------           -------------------------------
% h_surf   - surface plot                                   (ui_surf;)
% h_sign   - sign boundaries                                (ui_sign;)
% h_freq   - frequency response analysis                    (ui_freq;)
% h_impr   - impulse response analysis                      (ui_imp;)
% h_traj   - adapt equalizer                                (ui_traj;)
% h_clr    - clear traces                                   (ui_clr;)
% h_help   - generates matlab5 help-window for BERGulator   --
% h_quit   - quits the BERGulator   			    --
%
% handles to user-interface messages 
% ----------------------------------
% h_msg    - message appearing below "Help" button
% h_msg2   - message appearing below "Freq/Imp" buttons
%
%
% ----------------------------------------------------------------------
%
%    BERGulator written by:    Phil "Bert" Schniter
%                              Blind Equalization Research Group
%                              Cornell University
%                              June 1997
%
%    			       Copyright 1997-1998 Phil Schniter
%
%
%    this file last updated 2/10/98
%
%
% See also BERGULATOR


 % some user parameters
 global  c SNR mu N is_FSE dse_alpha;

 % calculated quantities
 global  C E F Rxx sigma2_n kappa;

 % ideal and optimal responses 
 global  delta_opt h_opt f_opt mse_opt h_glob;

 % lengths
 global  N_c N_f N_h M_s;

 % used in ui_traj.m
 global  f_init y srcme cme_filt mserr mse_filt f D_f D_e h_best f_cur;

 % locally desired responses
 global  h_des f_des mse_des h_loc;

 % valid after sign boundaries are drawn
 global  alphabet S grad_mag;

 % handles to ui parameters
 global  h_chan h_fse h_source h_coefs h_SNR h_norm h_axes h_N_f h_alg...
  	 h_spike h_num h_col h_step h_smooth;

 % handles to ui actions
 global  h_surf h_sign h_freq h_impr h_traj h_clr h_help;

 % handles to ui messages
 global  h_msg h_msg2;

 % handles to figures
 global fig_menu fig_surf fig_freq fig_imp fig_hist fig_scat fig_taps;

 % behavioral options
 global  no_traj_plots alg_surf;
