function mask = vdsmask(N,M,p,sd)
% Ahmad.46@osu.edu modified this function to: (i) sample both halves, (ii)
% shift the center to (floor(N/2)+1, floor(M/2)+1), and (iii) make 0<p<1

% sopt_mltb_vdsmask - Create variable density sampling profile
%
% Creates a binary mask generated from a variable density sampling 
% profile for two dimensional images in the frequency domain.   The mask 
% contains on average p*N*M ones's.
%
% Inputs:
%
%   - N and M: Size of mask.
%
%   - p: Coverage percentage.
%
%   - sd: Seed
% Note: The undersampling ratio is passed as 2*p and then the function
% only takes samples in half plane to account for signal reality. The range
% of p is 0 < p <= 0.5.
%
% Outputs:
%
%   - mask: Binary mask with the sampling profile in the frequency domain.

% p = 2*p;

if nargin<4
    sd = 1;
end

if p==1
    mask=ones(N,M);
else  
    nb_meas=round(p*N*M);
    tol=ceil(p*N*M)-floor(p*N*M);
    d = 1/3; % controls sampling density
 
%     [x,y] = meshgrid(linspace(-1, 1, M), linspace(-1, 1, N)); % Cartesian grid
    [x,y] = meshgrid(linspace(-1, 1-2/M, M), linspace(-1, 1-2/N, N)); % (Correction by ahmad.46@osu.edu)

    r = sqrt(x.^2+y.^2); r = r/max(r(:)); % Polar grid

    alpha=-1;
    it=0;
    maxit=20;
    while (alpha<-0.01 || alpha>0.01) && it<maxit
        pdf = (1-r).^d;
        [new_pdf,alpha] = sopt_mltb_modifypdf(pdf, nb_meas);
        if alpha<0
            d=d+0.025; % Also impacts the sampling density
        else
            d=d-0.025;
        end
        it=it+1;
    end

    mask = zeros(size(new_pdf));
    rng(sd);
    while sum(mask(:))>nb_meas+tol || sum(mask(:))<nb_meas-tol
        mask = rand(size(new_pdf))<new_pdf;
    end
end

% figure; imagesc(mask); axis('image'); colormap('gray');



function [new_pdf, alpha] = sopt_mltb_modifypdf(pdf, nb_meas)
% sopt_mltb_modifypdf - Modify PDF of sampling profile
% 
% Checks PDF of the sampling profile and normalizes it. It is used
% in sopt_mltb_vdsmask in the generation of variable density sampling
% profiles.
%
% Inputs:
%
%   - pdf: Sampling profile function.
%   - nb_meas: Number of measurements.
%
% Outputs:
%
%   - new_pdf: New sampling profile function.
%   - alpha: DC level for the required number of samples.

if sum(pdf(:)<0)>0
    error('PDF contains negative values');
end
pdf = pdf/max(pdf(:));

% Find alpha
alpha_min = -1; alpha_max = 1;
while 1
    alpha = (alpha_min + alpha_max)/2;
    new_pdf = pdf + alpha;
    new_pdf(new_pdf>1) = 1; new_pdf(new_pdf<0) = 0;
    M = round(sum(new_pdf(:)));
    if M > nb_meas
        alpha_max = alpha;
    elseif M < nb_meas
        alpha_min = alpha;
    else
        break;
    end
end





