function [A, At] = sensingMatrix(param, ac)

n    = param.n;
senM = param.senM;
sd0   = param.sd;
c  = floor(n/2)+1;
k  = 0; % 1/2 size of the fully sampled fft patach in the middle

if strcmp(senM, 'iidG') % IID Gaussian
    rng(sd0);
    G = randn(round(n(1)*n(2)*ac), n(1)*n(2))/sqrt(n(1)*n(2)*ac); % Random matrix
    A  = @(x) G*x(:);
    At = @(x) reshape(G'*x,n);
elseif strcmp(senM, 'fft-vr') % 2D fft with radom sampling (variable density)
    msk = vdsmask(n(1), n(2), ac, sd0);
    msk(c(1)-k:c(1)+k, c(2)-k:c(2)+k)=1;
    figure; imagesc(msk); axis('image'); colormap('gray');
    msk = ifftshift(msk); % Variable density mask
    ind = find(msk==1);
    Ma = sparse(1:numel(ind), ind, ones(numel(ind), 1), numel(ind), n(1)*n(2));
    A  = @(x) Ma*reshape(fft2(x)/sqrt(numel(x)), numel(x), 1);
    At = @(x) (ifft2(reshape(Ma'*x(:),n))*sqrt(numel(x)));
elseif strcmp(senM, 'fft-rd') % 2D fft with radial sampling
    msk = radialCartesianSampling(ceil(ac*sqrt(2)*max(n)), n);
    figure; imagesc(msk); axis('image'); colormap(gray);
    msk = ifftshift(msk);
    ind = find(msk==1);
    Ma = sparse(1:numel(ind), ind, ones(numel(ind), 1), numel(ind), n(1)*n(2));
    A  = @(x) Ma*reshape(fft2(x)/sqrt(numel(x)), numel(x), 1);
    At = @(x) (ifft2(reshape(Ma'*x(:),n))*sqrt(numel(x)));
elseif strcmp(senM, 'sFFT'); % 2D fft with random, uniform undersampling for "spread spectrum" for incoherence
    rng(101*sd0);
    pm = 2*(rand(n(1), n(2)) >= 0.5)-1; % +/- one mask
%     pm = pm.*exp(1j*2*pi*(rand(n(1), n(2))));
     
    % Note: for real image, each complex measurement counts as two
    % measurements. To compensate for that I have removed half of the
    % measurements
    if param.rlPhi == 1
        rng(sd0);
        msk = double(rand(n(1), n(2)) >= (1-ac));
        msk(2:floor(end/2), 2:end) = 0;     % empty one half except for the periphery
        msk(floor(end/2)+1:end, 2:end) = 2* msk(floor(end/2)+1:end, 2:end); % identify the 2nd half
        msk(floor(end/2)+1,2:floor(end/2))=0; % Set half of the "central line to zero
%         figure; imagesc(msk);

        % Delete half of the periphral points
        ind = find(msk==1);
        rng(9*sd0);
        ind = randsample(ind, floor(numel(ind)/2));
        msk(ind) = 0;
%         figure; imagesc(msk);
        
        % Delete half of the second half points
        ind = find(msk==2);
        rng(19*sd0);
        ind = randsample(ind, floor(numel(ind)/2));
        msk(ind) = 0;
        
        % Replicate the point in the 1st half
        [xInd,yInd] = ind2sub(n, ind);
        xInd = c(1)*2 - xInd;
        yInd = mod(c(2)*2 - yInd - 1, n(2))+1;
        ind = sub2ind(n, xInd, yInd);
        msk(ind) = 1;
        msk = logical(msk);
%         figure; imagesc(msk);
        
        msk = ifftshift(msk); 
        ind = find(msk==1);
        Ma = sparse(1:numel(ind), ind, ones(numel(ind), 1), numel(ind), n(1)*n(2));
        A  = @(x) [Ma*reshape(real(fft2(pm.*x))/sqrt(numel(x)), numel(x), 1); Ma*reshape(imag(fft2(pm.*x))/sqrt(numel(x)), numel(x), 1)];
        At = @(x) 2*conj(pm).*real(ifft2(reshape(Ma'*(x(1:end/2) + 1j*x(end/2+1:end)),n))*sqrt(numel(x)));

%         save msk msk;
        
     
    elseif param.rlPhi == 0
        rng(501*sd0);
        pm = pm.*exp(1j*2*pi*(rand(n(1), n(2)))); % to keep the image real
        rng(sd0);
        msk = rand(n(1), n(2)) >= (1-ac); % No conjugate symmetry
        
        msk = ifftshift(msk); 
        ind = find(msk==1);
        Ma = sparse(1:numel(ind), ind, ones(numel(ind), 1), numel(ind), n(1)*n(2));
        A  = @(x) Ma*reshape(fft2(pm.*x)/sqrt(numel(x)), numel(x), 1);
        At = @(x) conj(pm).*(ifft2(reshape(Ma'*x(:),n))*sqrt(numel(x))); 

    end
    
% %     figure; subplot(121); imagesc(abs(pm)); axis('image'); colormap('gray'); title('+/- modulation');
% %             subplot(122); imagesc(msk); axis('image'); colormap('gray'); title('Fourier downsampling mask');
%     msk = ifftshift(msk); 
%     ind = find(msk==1);
%     Ma = sparse(1:numel(ind), ind, ones(numel(ind), 1), numel(ind), n(1)*n(2));
%     A  = @(x) Ma*reshape(fft2(pm.*x)/sqrt(numel(x)), numel(x), 1);
%     At = @(x) conj(pm).*(ifft2(reshape(Ma'*x(:),n))*sqrt(numel(x)));  
    
elseif strcmp(senM, 'kt2'); % 1D undersampled fft, independent in each time frame
    msk = zeros(n);
    for i=1:n(2)
        sd = sd0+i*3+100;
        tmp = oneDRandomSampling(ceil(ac*n(1)), flip(n), 10, n(1)/6, sd);
        tmp = tmp(1,:)';
        if param.rlPhi == 1
            tmp(1:floor(end/2), :) = 0; % partial fourier
            ind = find(tmp==1);
            rng(11*sd0+i*6);
            ind = randsample(ind, floor(numel(ind)/2));
            tmp(c(1)*2 - ind) = 1;
            tmp(ind) = 0;
        end
        msk(:,i) = tmp;
    end
%     msk(c(1),:) = 1;
%     figure; imagesc(msk);
    msk = ifftshift(msk,1);
%     figure; imagesc(msk);
    ind = find(msk==1);
    Ma = sparse(1:numel(ind), ind, ones(numel(ind), 1), numel(ind), n(1)*n(2));
    A  = @(x) Ma*reshape(fft(x)/sqrt(n(1)), numel(x), 1);
    At = @(x) ifft(reshape(Ma'*x(:),n))*sqrt(n(1));

end
    
    