function [p] = paramShepplogan(x)

% Simulation setup
p.d        = ndims(x); % Image dimensions
p.n        = size(x);  % image size;
p.sd       = 2; % Seed for sensing matrix realization and noise
p.senM     = 'sFFT'; % Sensing matrix; 'sFFT' is for spread spectrum
p.dict     = {'db1'}; % sparsifying transform: sub-bands of db1, 
p.decm     = 0;  % 0 for undecimate and 1 for decimated wavelet transform.
p.N        = 1;  % level of decomposition
p.rlPhi    = 0;  % '1' if the input image and measurements are real; '0' for complex
p.rlPsi    = 0;  % '1' if the coefficients in the sparsifying domain are real; 0 for complex 
                 
p.snr      = 30;  % input noise dB
p.acce     = 0.3; % sampling ratio = number of measurements/numer of pixels


% FISTA related
p.oIter    = 16;  % Outer re-weighting iterations
p.iIter    = 100; % Inner FISTA iterations
p.minIter  = ceil(p.iIter/4); % Minimum number of inner iterations to run for each outer iteration
p.stpThrsh = 1e-6; % Stopping threshold
p.L1       = []; % Lipschitz constant for the fidelity term; will be calculated if left empty
p.L2       = 2.05; % Lipschitz constant for the regularization term; will be calculated if left empty
p.mu0      = 1;   % Initial mu used in mFISTA
p.muf      = 0.1; % Final mu used in mFISTA
p.mur      = (p.mu0/p.muf)^(1/(p.oIter*0.9)); % mu reduction factor schedule used in mFISTA
p.v        = 5; % Vebocity level; '1' for max verbocity; larger number reduces verbocity
p.fvr      = 's'; % FISTA's version, 's' for Samuel Ting's (samual.ting@osumc.edu) approximate (but x3 faster) 
                  % version and 'm' for mFISTA; 's' requires \Psi' * \Psi = Identity, 
                  % while 'm' does not have this requirement.
p.nFtr     = 1; % Global scaling of the noise power
p.sFtr     = 1; % Global scaling of the composite sparsity term
p.epni     = 2e1; % For IRW-L1, change epsilon for p.epni to p.epnf over p.oIter
p.epnf     = 1;   