function [samp] = oneDRandomSampling(nLin, n, dc, stDev, sd)

% Generates 2D sampling pattern with one dimension fully sampled and other picked randomly

% nLin: Number of fully sampled lines
% n:    Size of the grid can be assymetric and does not have to be even sized
% dc and stDev:  These two parameters define the variable density profile used for random sampling
% samp: 2D binary mask

% Rizwan Ahmad (ahmad.46@osu.edu)
% Last Modified: 7/27/2014



if nargin<2
    error('Not enough input arguments.');
elseif nargin==3
    dc = 0.5;
    stDev = n(2)/4;
    sd = rng;
elseif nargin==3
    stDev = n(2)/4;
    sd = rng;
elseif nargin==4
    sd = rng;
end

if ndims(n) ~= 2 || sum(n<2) || sum(rem(n,1))
     error('Invalid grid size');
end

if nLin < 1 || nLin > n(2)
    error('Incorrect number of lines')
end

if stDev <= eps || dc <0
    error('Incorrect parameter values')
end


p1=(-floor(n(2)/2):ceil(n(2)/2)-1)';
% p1=(-floor(n(1)/2):ceil(n(1)/2)-1)';

prob = dc + exp(-(p1).^2./(1*stDev.^2));
rng(sd)
sd = round(1e6*rand(nLin,1));
ln = zeros(nLin,1);
for i = 1:nLin
    lnTmp = randp(prob, 1, sd(i));
    ln(i) = lnTmp;
    prob(lnTmp) = 0;
end

samp = zeros(n);
samp(:,ln) = 1;
% samp(ln,:) = 1;
% figure; imagesc(samp); axis('image'); colormap('gray');
