function [x] = minH(A, U, CoefG, b, x, z, mu, lam)

objx = A(x) - b;
objx = 1/2 * objx(:)'*objx(:);
objx = objx + hubFun(CoefG, lam, mu);


objz = A(z) - b;
objz = 1/2 * objz(:)'*objz(:);
objz = objz + hubFun(U(z), lam, mu);

if abs(objz) < abs(objx)
    x = z;
end


function [y] = hubFun(coef, lam, mu)
ind1 = abs(coef) <  (lam*mu);
ind2 = abs(coef) >= (lam*mu);
coef(ind1) = 1./(2*mu*lam(ind1)) .* abs(coef(ind1)).^2;
coef(ind2) = abs(coef(ind2)) - (mu*lam(ind2))/2;
y = sum(lam(:).*coef(:));











