function [x, L, G] = mFST_Rwl1(b, x0, param)
%-----------------------------------------------------------------------
% Adhmad.46@osu.edu
% Last modified: Feb. 17, 2017
%-----------------------------------------------------------------------
 
tcSENSE  = tic;

nCoef    = param.bInd(end); % Number of coeficients
% dctSz    = numel(param.bInd)-1;  % Number of sub-bands
n        = param.n; 
A        = param.A;
At       = param.At;
U        = param.U;
Ut       = param.Ut;
iIter    = param.iIter; % Inner iteration
oIter    = param.oIter; % Outer iteration
minIter  = param.minIter;
stpThrsh = param.stpThrsh;
lmb0     = param.lmb0;
epn0     = param.epn0;
epni     = param.epni;
epnf     = param.epnf;
% cExp     = param.cExp;
L1       = param.L1;
L2       = param.L2;
mu0      = param.mu0;
muf      = param.muf;
mur      = param.mur;
v        = param.v;
fvr      = param.fvr;
rw       = param.rw;
% nStd     = param.nStd;
% tObj     = sqrt(numel(b)*nStd*nStd); % Target objective function value




%Use the power iteration to estimate the Lipschitz constant if not provided
if isempty(L1)
    L1 = 2.05*powerIter(param.A, param.At, size(x0));
end
if isempty(L2)
    L2 = 2.05*powerIter(param.U, param.Ut, size(x0));
end


% Initialization
epnScl = [epni*ones(round(0.5*oIter),1); epni*10.^(log10(epnf/epni) .* (1:round(oIter*0.25))'/round(oIter*0.25));...
          epnf*ones(oIter - round(0.5*oIter) - round(0.25*oIter),1)];
wt = ones(nCoef,1);
mu = max(mu0./mur.^(0:oIter-1), muf);

x = x0; clear x0;
z = x;
y = x;
t = 1;
% g = 'nan';

[objDF, objWav] = wObjective(b, x, lmb0.*wt, param);
disp(['Initial objective function: ' sprintf('%0.3f',objDF) ' + ' ...
      sprintf('%0.3f',objWav) ' = ' sprintf('%0.3f',objDF+objWav)]);


for o = 1:oIter % outer (reweighting) iteration
    stop = 0;
    iter = 0;
    L3 = L1 + L2/mu(o);
    Ux = U(x);
    if param.adap ==0
        param.Nlim = inf;
        [lmb, L, G] = findWFst(Ux, epnScl(o), param, numel(b), lmb0, epn0);   
    elseif o<ceil(0.4*oIter) && param.adap == 2 % Use Co-L1 as an initialization for Co-IRW-L1
        param.Nlim = 5;
        param.rw  = 0;
        [lmb, L, G] = findWFst(Ux, epnScl(o), param, numel(b),epnScl);
    else
        param.Nlim = inf;
        param.rw   = rw;
        [lmb, L, G] = findWFst(Ux, epnScl(o), param, numel(b),epnScl);
    end
    clear Ux;
 

    while iter<iIter && stop==0 % inner iteration that solves the convex problem
        tStart = tic;
        iter = iter+1; 
        
        if strcmp(fvr, 's') % 'Sam's version of FISTA, only works when UtU = I
            coefG = U(z - 1/L1 * wGradient(b, z, A, At));
            coefG = shrink(coefG, lmb/L1);
            x_new = Ut(coefG);
            t_new = (1 + sqrt(1 + 4*t^2))/2;
            z = x_new + (t - 1)/t_new*(x_new - x);
            x_old = x;
            x = x_new;
            t = t_new;
        
        elseif strcmp(fvr, 'm') % Beck's mFISTA, slower but does not require UtU = I
            df = 1/2 * wGradient(b, y, A, At);
            coefG = U(x);
            dg = 1/mu(o) * Ut(coefG - shrink(coefG, lmb*mu(o)));
            z = y - 1/L3 * (df + dg);
            t_new = (1 + sqrt(1 + 4*t^2))/2;
            x_new = minH(A, U, coefG, b, x, z, mu(o), lmb);
    %         x_new = z;
            y = x_new + t/t_new * (z - x_new) + (t-1)/t_new * (x_new - x);
            x_old = x;
            x = x_new;
            t = t_new;
        end


        if iter>minIter && (norm(x_new(:) - x_old(:)) / norm(x_new(:))) < stpThrsh
            disp('Stopping threshold reached, terminating inner loop');
            stop = 1;
        end

    end
    [objDF, objWav] = wObjective(b, x, lmb, param);
    if rem(o,v) == 0 || o==oIter
        disp(['OuterIter: ' num2str(o) ', time/InnerIter: ' sprintf('%0.2f', toc(tStart)) 's, objective: ' sprintf('%0.3f',objDF) ' + ' sprintf('%0.3f',objWav) ' = ' sprintf('%0.3f',objDF+objWav)]);
    end

end
% lmb = lmb / (param.cFtr * nStd^2); % lambda after removing the noise scaling applied in findWFst.m
disp(['Total recovery time: ' sprintf('%0.2f', toc(tcSENSE)) sprintf('\n')]);