function [I] = getAnisoImage2D(n, sd, k)


%%
p1 = k(1); % n(1)-k;%round(   n(1)* 0.5); % Number of transitions in the first dimension
p2 = k(2);%round(k.*n(2)* 0.5); % Number of transitions in the second dimension

if p1>n(1) || p2>n(2)
    error('the number of transitions has to lesser than the number of pixels');
end

% First dimension
rng(sd*5);
v = sort([1; randsample(n(1)-2,p1)+1; n(1)]);
tmp = cumsum(randn(numel(v)-1,1));
I1 = zeros(n(1),1);
for i=1:numel(v)-1
    I1(v(i):v(i+1)) = tmp(i);
end
I1 = repmat(I1,[1,n(2)]);
% figure; imagesc(I1);
% return;

% Second dimension
rng(sd*11);
v = sort([1; randsample(n(2)-2,p2)+1; n(2)]);
tmp = cumsum(randn(numel(v)-1,1));
I2 = zeros(1,n(2));
for i=1:numel(v)-1
    I2(v(i):v(i+1)) = tmp(i);
end
I2 = repmat(I2,[n(1),1]);

I = I1 + I2;
% figure; imagesc(I); axis('image');



%%
% p1 = round(n(1)* 0.15); % Number of transitions in the first dimension
% p2 = round(n(2)* 0.0); % Number of transitions in the second dimension
% 
% % First dimension
% rng(sd*5);
% v = sort([1;randsample(n(1)-1,p1)+1]);
% tmp = cumsum(randn(numel(v)-1,1));
% I = zeros(n(1),1);
% for i=1:numel(v)-1
%     I(v(i):v(i+1)) = tmp(i);
% end
% I = repmat(I,[1,n(2)]);
% % figure; plot(I(:,1));
% 
% % Second dimension
% rng(sd*11);
% j = sort([randsample(n(2)-1,p2);n(2)]);
% tmp = randn(numel(j)-1,1);
% tmp = cumsum(sign(tmp).*(ceil(abs(tmp))));
% for i=1:numel(j)-1
%     I(:,j(i)+1:j(i+1)) = circshift(I(:,j(i)+1:j(i+1)),[tmp(i),0]);
% end
% I = I + k*I';
% figure; imagesc(I); axis('image');
% 
