function [y, nStd, sclFctr] = genNoisyData(param, x)

% param: parameters
% x: input image

% y: noisy data
% nStd: std of additive noise
% sclFctr: Scaling factor used

snr = param.snr;
A   = param.A;
sd  = param.sd;



y0    = A(x);
nStd  = sqrt(10^((10*log10(sum(abs(y0(:)).^2)/length(y0(:))) - snr)/10)); % Additive noise according to SNR (dB) defined
if isreal(y0) % real
    rng(sd*9+666);
    y  = y0 + nStd*randn(size(y0));
else          % complex
    rng(sd*9+666);
    y  = y0 + 1/sqrt(2)*nStd*(randn(size(y0)) + 1j*randn(size(y0)));
%     figure; imagesc(real(y-y0)); colorbar; figure; imagesc(imag(y-y0));colorbar; ttt
end
sclFctr = 100/norm(y(:)); % Normalize y for numerical stability
y    = y*sclFctr;
nStd = nStd*sclFctr;