function [wt, L, E] = findWFst(coefX, epnScl, param, meas,lmb,epn)
% Estimate tuning parameters

bInd   = param.bInd;
dctSz  = numel(bInd)-1;
nCoef  = bInd(end);
adap   = param.adap;
nStd   = param.nStd;
nStdW  = nStd*sqrt(meas/numel(coefX)); % Noise in transform domain
rw     = param.rw;
% scl    = param.scl;
Nlim   = param.Nlim;
rlPhi  = param.rlPhi;
rlPsi  = param.rlPsi;
wt = zeros(nCoef,1);
avCoefX = mean(abs(coefX(:)));

if rlPhi == 1 % if the data residual is real
    nFtr   = 2 * param.nFtr * nStd^2;
elseif rlPhi ==0
    nFtr   = 1 * param.nFtr * nStd^2;
end

if rlPsi == 1 % if the coeffficients are real
    sFtr   = 1 * param.sFtr;
elseif rlPsi ==0
    sFtr   = 2 * param.sFtr;
end


E = [];
if  adap == 0 % Non-adaptive, uses user defined lambda
    if rw == 0
        L = lmb;
        wt = nFtr * sFtr * repmat(L, [nCoef, 1]);
        
    elseif rw == 1
        E  = epn*(epnScl+eps); %max(abs(coefX(:)))*(gama+eps);
        E  = max(nStdW/10, E);
        L  = lmb;
        wt = nFtr * sFtr * L*sqrt(epnScl)./(abs(coefX) + E); 
    end

elseif  adap == 1 % Auto-tunes one scalar \lambda
    if rw == 0
        L = 1/(sum(abs(coefX))/numel(coefX) + 1e-2*avCoefX);
        wt = nFtr * sFtr * ones(nCoef,1)*L;
       
    elseif rw == 1
        warning('off');
        [L, E] = AbsLogHistFit(coefX,[bInd(1), bInd(end)],param,epnScl);
        warning('on');
%         E  =  E*(epnScl+eps);
        E  = max(nStdW/10, E);
        wt = nFtr * L *sqrt(1)./(abs(coefX) + E); 
    end
     
elseif  adap == 2
    if rw == 0
        L   = ones(dctSz, 1);
        for j = 1:dctSz 
            L(j) = 1/(sum(abs(coefX(bInd(j)+1:bInd(j+1))))/numel(coefX(bInd(j)+1:bInd(j+1))) + 1e-2*avCoefX); % The numerator becomes "2" for complex Laplacian prior; 1e-3 some random scaling to keep numbers small
            wt(bInd(j)+1:bInd(j+1)) = nFtr * sFtr *L(j);
        end
        wt(wt > Nlim*min(wt(:))) = Nlim*min(wt(:));
        L(L   > Nlim*min(L(:)))  = Nlim*min(L(:));
        
    elseif rw ==1
        warning('off');
        [L, E] = AbsLogHistFit(coefX,bInd,param,epnScl); 
        warning('on');
%         E = E*(epnScl+eps);
        E = max(nStdW/10, E);
        for i = 1:dctSz
            wt(bInd(i)+1:bInd(i+1)) =  nFtr * L(i) .* sqrt(1)./(abs(coefX(bInd(i)+1:bInd(i+1))) + E(i)); %sig*sureShrink(coefX(bInd(i)+1:bInd(i+1)));
        end
    end
%     max(abs(wt)),
end
