function [lmb, epn, fval] = AbsLogHistFit(bands, bInd, param,epnScl)
% Numerically fits histogram to find hyper-parameters

rl = param.rlPsi;
dctSz  = numel(bInd)-1;
% nCoef  = bInd(end);

% bands = abs(bands);
options = optimset('Display','off','TolFun',1e-6,...
                   'TolX',1e-6,'MaxIter',500,'MaxFunEval',500);
lmb  = zeros(dctSz,1);
epn  = zeros(dctSz,1);
av   = mean(abs(bands(:)));
defLmb = 1.2; % Default value of lambda


for i = 1:dctSz
    y = abs(bands(bInd(i)+1:bInd(i+1)));
    n = numel(y);
    meanData = (av/2 + max(y)/5)*epnScl; % Initialization of epsilon

    if max(y) == 0
        epn(i)  = 1e-2*av;
        lmb(i) = 2;
    else

    if rl == 1
       f1  = @(x) -n*log(    1/2*(x(2)-1)*(x(1)^(x(2)-1))    ) + x(2)*sum(log(y+x(1)));
       x1_0 =  [meanData,    defLmb       ];
       x1_lb = [x1_0(1)/1e2, 1.01]; % putting bounds is not necessary but sometimes help avoid bad local minima
       x1_ub = [x1_0(1)*1e3, 2.00];
        
    elseif rl == 0
       f1  = @(x) -n*log(    1/(2*pi)*(x(2)-1)*(x(2)-2)*(x(1)^(x(2)-2))    ) + x(2)*sum(log(y+x(1)));
       x1_0 =  [meanData,    2*defLmb       ];
       x1_lb = [x1_0(1)/1e2, 2.01]; % putting bounds is not necessary but sometimes help avoid bad local minima
       x1_ub = [x1_0(1)*1e3, 4.00];
    end
               
    [xHat, fval(1)] = fmincon(f1,x1_0,[],[],[],[],x1_lb,x1_ub,[],options);
    
    epn(i)  = xHat(1);
    lmb(i) = xHat(2);
    end
    
end