function [U, Ut, ind] = wavWrap(x, p)

dict = p.dict;
if isfield(p, 'decm')
    decm = p.decm;
else
    decm = 2;
end
n    = p.n;
d    = p.d;
N    = p.N; % level of decomposition

%% 2D image
if d == 2
    if strcmp(dict, 'fd') % finite difference
        if p.N ~= 2 && p.N ~= 4
            error('Incorrect value assigned to p.N')
        end
        U   = @(x) finDiff_2D(x,  1, p);
        Ut  = @(x) finDiff_2D(x, -1, p);
        ind = [0, n(1)*n(2):n(1)*n(2):p.N*n(1)*n(2)];
        
    elseif decm == 0% undecimated wavelet
        nddwt = cell(1,numel(dict));
        for i = 1:numel(dict)
            nddwt{i} = nd_dwt_2D(dict{i},n);
        end
        if numel(dict)==1
            U  = @(x) reshape(nddwt{1}.dec(x,N),[],1); % myfun(nddwt, x, N); 
            Ut = @(x) nddwt{1}.rec(x,N); % myfun2(nddwt,x, N); 
%             U  = @(x) myfun(nddwt, x, N); 
%             Ut = @(x) myfun2(nddwt,x, N);
        elseif numel(dict)==2
            U  = @(x) [reshape(nddwt{1}.dec(x,N),[],1); reshape(nddwt{2}.dec(x,N),[],1)];
            Ut = @(x) 1/2*(nddwt{1}.rec(x(1:round(end/2)),N) + nddwt{2}.rec(x(round(end/2)+1:end),N));
        elseif numel(dict)==3
            U  = @(x) [reshape(nddwt{1}.dec(x,N),[],1); reshape(nddwt{2}.dec(x,N),[],1); reshape(nddwt{3}.dec(x,N),[],1)];
            Ut = @(x) 1/3*(nddwt{1}.rec(x(1:round(end/3)),N) + nddwt{2}.rec(x(round(end/3)+1:round(2/3*end)),N) +...
                           nddwt{3}.rec(x(round(2/3*end)+1:end),N));
        elseif numel(dict)==4
            U  = @(x) [reshape(nddwt{1}.dec(x,N),[],1); reshape(nddwt{2}.dec(x,N),[],1); reshape(nddwt{3}.dec(x,N),[],1); reshape(nddwt{4}.dec(x,N),[],1)];
            Ut = @(x) 1/4*(nddwt{1}.rec(x(1:round(end/4)),N) + nddwt{2}.rec(x(round(end/4)+1:round(end/2)),N) + ...
                           nddwt{3}.rec(x(round(end/2)+1:round(3*end/4)),N) + nddwt{4}.rec(x(round(3*end/4)+1:end),N));
        elseif numel(dict)==5
            U  = @(x) [reshape(nddwt{1}.dec(x,N),[],1); reshape(nddwt{2}.dec(x,N),[],1); reshape(nddwt{3}.dec(x,N),[],1); reshape(nddwt{4}.dec(x,N),[],1); reshape(nddwt{5}.dec(x,N),[],1)];
            Ut = @(x) 1/5*(nddwt{1}.rec(x(1:round(end/5)),N) + nddwt{2}.rec(x(round(end/5)+1:round(2*end/5)),N) + ...
                           nddwt{3}.rec(x(round(2*end/5)+1:round(3*end/5)),N) + nddwt{4}.rec(x(round(3*end/5)+1:round(4*end/5)),N) + ...
                           nddwt{5}.rec(x(round(4*end/5)+1:end),N));
        else
            error('only up to five non-decimated transformed can be included at one time');
        end 
        sz = prod(n);
        ind = [0,sz:sz:(4+(N-1)*3)*sz*numel(dict)];

    elseif decm == 1
        p.coefSt =  d_dbx_2D_mat(x,  0, p);
        U    = @(x) d_dbx_2D_mat(x,  1, p); % repmat(permute(x/4,[3,1,2]),[4,1,1]); 
        Ut   = @(x) d_dbx_2D_mat(x, -1, p); % squeeze(sum(x,1));
        ind = p.coefSt{end}.ind;
    end

%% For 3D imagin
elseif d == 3
    if strcmp(dict, 'fd') % finite difference
        error('A wrapper for 3D finite difference has not be implemented yet');
    
    elseif decm == 0 % undecimated wavelet
        nddwt = cell(1,numel(dict));
        for i = 1:numel(dict)
            nddwt{i} = nd_dwt_3D(dict{i},n);
        end
        if numel(dict)==1
            U  = @(x) reshape(nddwt{1}.dec(x,N),[],1);
            Ut = @(x) nddwt{1}.rec(x,N);
        elseif numel(dict)==2
            U  = @(x) [reshape(nddwt{1}.dec(x,N),[],1); reshape(nddwt{2}.dec(x,N),[],1)];
            Ut = @(x) 1/2*(nddwt{1}.rec(x(1:round(end/2)),N) + nddwt{2}.rec(x(round(end/2)+1:end),N));
        elseif numel(dict)==3
            U  = @(x) [reshape(nddwt{1}.dec(x,N),[],1); reshape(nddwt{2}.dec(x,N),[],1); reshape(nddwt{3}.dec(x,N),[],1)];
            Ut = @(x) 1/3*(nddwt{1}.rec(x(1:round(end/3)),N) + nddwt{2}.rec(x(round(end/3)+1:round(2/3*end)),N) +...
                           nddwt{3}.rec(x(round(2/3*end)+1:end),N));
        elseif numel(dict)==4
            U  = @(x) [reshape(nddwt{1}.dec(x,N),[],1); reshape(nddwt{2}.dec(x,N),[],1); reshape(nddwt{3}.dec(x,N),[],1); reshape(nddwt{4}.dec(x,N),[],1)];
            Ut = @(x) 1/4*(nddwt{1}.rec(x(1:round(end/4)),N) + nddwt{2}.rec(x(round(end/4)+1:round(end/2)),N) + ...
                           nddwt{3}.rec(x(round(end/2)+1:round(3*end/4)),N) + nddwt{4}.rec(x(round(3*end/4)+1:end),N));
        elseif numel(dict)==5
            U  = @(x) [reshape(nddwt{1}.dec(x,N),[],1); reshape(nddwt{2}.dec(x,N),[],1); reshape(nddwt{3}.dec(x,N),[],1); reshape(nddwt{4}.dec(x,N),[],1); reshape(nddwt{5}.dec(x,N),[],1)];
            Ut = @(x) 1/5*(nddwt{1}.rec(x(1:round(end/5)),N) + nddwt{2}.rec(x(round(end/5)+1:round(2*end/5)),N) + ...
                           nddwt{3}.rec(x(round(2*end/5)+1:round(3*end/5)),N) + nddwt{4}.rec(x(round(3*end/5)+1:round(4*end/5)),N) + ...
                           nddwt{5}.rec(x(round(4*end/5)+1:end),N));
        else
            error('only up to five non-decimated transformed can be included at one time');
        end 
        sz = prod(n);
        ind = [0,sz:sz:(7*N+1)*sz*numel(dict)];

    elseif decm == 1 % Decimated wavelet
        error('A wrapper for 3D decimated wavelets has not been implemented yet');
    end
    
%% For 4D image    
elseif d == 4
    if strcmp(dict, 'fd') % finite difference
        error('A wrapper for 3D finite difference has not be implemented yet');
        
    elseif decm == 0 % Undecimated wavelet
        nddwt = cell(1,numel(dict));
        for i = 1:numel(dict)
            nddwt{i} = nd_dwt_4D(dict{i},n);
        end
        if numel(dict)==1
            U  = @(x) reshape(nddwt{1}.dec(x,N),[],1);
            Ut = @(x) nddwt{1}.rec(x,N);
        elseif numel(dict)==2
            U  = @(x) [reshape(nddwt{1}.dec(x,N),[],1); reshape(nddwt{2}.dec(x,N),[],1)];
            Ut = @(x) 1/2*(nddwt{1}.rec(x(1:round(end/2)),N) + nddwt{2}.rec(x(round(end/2)+1:end),N));
        elseif numel(dict)==3
            U  = @(x) [reshape(nddwt{1}.dec(x,N),[],1); reshape(nddwt{2}.dec(x,N),[],1); reshape(nddwt{3}.dec(x,N),[],1)];
            Ut = @(x) 1/3*(nddwt{1}.rec(x(1:round(end/3)),N) + nddwt{2}.rec(x(round(end/3)+1:round(2/3*end)),N) +...
                           nddwt{3}.rec(x(round(2/3*end)+1:end),N));
        elseif numel(dict)==4
            U  = @(x) [reshape(nddwt{1}.dec(x,N),[],1); reshape(nddwt{2}.dec(x,N),[],1); reshape(nddwt{3}.dec(x,N),[],1); reshape(nddwt{4}.dec(x,N),[],1)];
            Ut = @(x) 1/4*(nddwt{1}.rec(x(1:round(end/4)),N) + nddwt{2}.rec(x(round(end/4)+1:round(end/2)),N) + ...
                           nddwt{3}.rec(x(round(end/2)+1:round(3*end/4)),N) + nddwt{4}.rec(x(round(3*end/4)+1:end),N));
        elseif numel(dict)==5
            U  = @(x) [reshape(nddwt{1}.dec(x,N),[],1); reshape(nddwt{2}.dec(x,N),[],1); reshape(nddwt{3}.dec(x,N),[],1); reshape(nddwt{4}.dec(x,N),[],1); reshape(nddwt{5}.dec(x,N),[],1)];
            Ut = @(x) 1/5*(nddwt{1}.rec(x(1:round(end/5)),N) + nddwt{2}.rec(x(round(end/5)+1:round(2*end/5)),N) + ...
                           nddwt{3}.rec(x(round(2*end/5)+1:round(3*end/5)),N) + nddwt{4}.rec(x(round(3*end/5)+1:round(4*end/5)),N) + ...
                           nddwt{5}.rec(x(round(4*end/5)+1:end),N));
        else
            error('only up to five non-decimated transformed can be included at one time');
        end
            
        sz = prod(n);
        ind = [0,sz:sz:(15*N+1)*sz*numel(dict)];

    elseif decm == 1 % Decimated wavelet
        error('I have not implemented a wrapper for 4D decimated wavelets');
    end
end

% function [u] = myfun(wav, x, N)
% u = reshape(wav{1}.dec(x,N),[],1);
% [~,b] = sort(abs(u));
% u = u(b);
% save b b;
% 
% function [u] = myfun2(wav, x, N)
% load b;
% [~,c] = sort(b);
% x = x(c);
% u =   wav{1}.rec(x,N);