function [coef] = d_dbx_3D_mat(x, k, p)
% Wrapper for multi-level, 2D, decimated redundant wavelet.

dict   = p.dict; % wavelet families used
n      = p.n;    % size of the image
N      = p.N;    % I have only coded it for one level

    
    
if ~isfield(p,'coefSt')
    coefSt = [];
else
    coefSt = p.coefSt; % Structure of the wavelet coefficients
end


if k==0 % get the structure
    dwtmode('per');
    m = 0;
    for i = 1 : numel(dict)
        sTmp = wavedec3(x,N,dict{i});
%         sTmp = sTmp.sizes;
        coef{i} = sTmp.sizes;
        for j = 1:size(sTmp,1)-1
            if j==1,
                m = m+1;
                coefInd(m)   = prod(n)*(i-1)+ prod(coef{1}(j,:)); 
                coefInd(m+1) = coefInd(m)   + prod(coef{1}(j,:));
                coefInd(m+2) = coefInd(m+1) + prod(coef{1}(j,:));
                coefInd(m+3) = coefInd(m+2) + prod(coef{1}(j,:));
                coefInd(m+4) = coefInd(m+3) + prod(coef{1}(j,:));
                coefInd(m+5) = coefInd(m+4) + prod(coef{1}(j,:));
                coefInd(m+6) = coefInd(m+5) + prod(coef{1}(j,:));
                coefInd(m+7) = coefInd(m+6) + prod(coef{1}(j,:));
                m = m+7;
            else
                coefInd(m+1) = coefInd(m)   + prod(coef{1}(j,:));
                coefInd(m+2) = coefInd(m+1) + prod(coef{1}(j,:));
                coefInd(m+3) = coefInd(m+2) + prod(coef{1}(j,:));
                coefInd(m+4) = coefInd(m+3) + prod(coef{1}(j,:));
                coefInd(m+5) = coefInd(m+4) + prod(coef{1}(j,:));
                coefInd(m+6) = coefInd(m+5) + prod(coef{1}(j,:));
                coefInd(m+7) = coefInd(m+6) + prod(coef{1}(j,:));
                m = m+7;
            end
        end
        coef{i}.ind = [0, coefInd];
    end
    
    
    
elseif k==1 % forward operator (image to wavelet coefficients)
    s = numel(dict)*prod(n);
    coef = zeros(s,1);
    for i = 1 : numel(dict)
        coefTmp = wavedec3(x,N,dict{i})';
        coef((i-1)*prod(n)+1 : i*prod(n)) = coefTmp.dec{:}/sqrt(numel(dict));
    end

elseif k==-1 % backward operator (coefficients to image)
    coef = zeros(n);
    for i = 1:numel(dict)
        coef = coef + waverec3(x((i-1)*prod(n)+1 : i*prod(n)),coefSt{i}.S, dict{i})/sqrt(numel(dict));
    end
    
end



















% 
% dict   = p.dict; % wavelet families used
% n      = p.n;    % size of the image
% N      = 1;   % I have only coded it for one level
% d      = p.d; % Dimension of the image
% 
% if ~isfield(p,'coefSt')
%     coefSt = [];
% else
%     coefSt = p.coefSt; % Structure of the wavelet coefficients
% end
% 
% 
% if k==0 % get the structure
%     for i = 1 : numel(dict)
%         coef{i} = ndwt2(randn(n),N,dict{i},'mode','per');
%         coef{i}.dec = [];
%     end
%     
% elseif k==1 % forward operator (image to wavelet coefficients)
%     coef = zeros([numel(dict)*d^2, n]);
%     for i = 1: numel(dict) 
%         coefTmp{i}= ndwt2(x,N,dict{i},'mode','per');
%         coef((i-1)*4+1,:,:) = 1/numel(dict)*coefTmp{i}.dec{1};
%         coef((i-1)*4+2,:,:) = 1/numel(dict)*coefTmp{i}.dec{2};
%         coef((i-1)*4+3,:,:) = 1/numel(dict)*coefTmp{i}.dec{3};
%         coef((i-1)*4+4,:,:) = 1/numel(dict)*coefTmp{i}.dec{4}; 
% %         figure; subplot(221); imagesc(coefTmp{i}.dec{1});
% %                 subplot(222); imagesc(coefTmp{i}.dec{2});
% %                 subplot(223); imagesc(coefTmp{i}.dec{3});
% %                 subplot(224); imagesc(coefTmp{i}.dec{4}); 
%     end
% 
% elseif k==-1 % backward operator (coefficients to image)
%     coef = zeros(n);
%     for i = 1:numel(dict);
%         coefSt{i}.dec{1} = squeeze(x((i-1)*4+1,:,:));
%         coefSt{i}.dec{2} = squeeze(x((i-1)*4+2,:,:));
%         coefSt{i}.dec{3} = squeeze(x((i-1)*4+3,:,:));
%         coefSt{i}.dec{4} = squeeze(x((i-1)*4+4,:,:));
%         coef = coef + indwt2(coefSt{i});
%     end
% end
% % figure; imagesc(x); title(['RMSE: ' num2str(norm(x(:)-x2(:))/norm(x(:)))]);
% 
% 
% 
