function [coef] = d_dbx_2D_mat(x, k, p)
% Wrapper for multi-level, 2D, decimated redundant wavelet.

dict   = p.dict; % wavelet families used
n      = p.n;    % size of the image
N      = p.N; % I have only coded it for one level

    
    
if ~isfield(p,'coefSt')
    coefSt = [];
else
    coefSt = p.coefSt; % Structure of the wavelet coefficients
end


if k==0 % get the structure
    dwtmode('per');
    m = 0;
    for i = 1 : numel(dict)
        [~, sTmp] = wavedec2(x,N,dict{i});
        coef{i}.S = sTmp;
        for j = 1:size(sTmp,1)-1
            if j==1,
                m = m+1;
                coefInd(m) = n(1)*n(2)*(i-1) + coef{i}.S(j)*coef{i}.S(j+size(sTmp,1)); 
            else
                coefInd(m+1) = coefInd(m)   + coef{i}.S(j)*coef{i}.S(j+size(sTmp,1));
                coefInd(m+2) = coefInd(m+1) + coef{i}.S(j)*coef{i}.S(j+size(sTmp,1));
                coefInd(m+3) = coefInd(m+2) + coef{i}.S(j)*coef{i}.S(j+size(sTmp,1));
                m = m+3;
            end
        end
        coef{i}.ind = [0, coefInd];
    end
    
    
    
elseif k==1 % forward operator (image to wavelet coefficients)
    s = numel(dict)*n(1)*n(2);
    coef = zeros(s,1);
    for i = 1 : numel(dict)
        coefTmp = wavedec2(x,N,dict{i})';
        coef((i-1)*n(1)*n(2)+1 : i*n(1)*n(2)) = coefTmp/sqrt(numel(dict));
    end

elseif k==-1 % backward operator (coefficients to image)
    coef = zeros(n);
    for i = 1:numel(dict)
        coef = coef + waverec2(x((i-1)*n(1)*n(2)+1 : i*n(1)*n(2)),coefSt{i}.S, dict{i})/sqrt(numel(dict));
    end
    
    
% %     s = size(x,1)/numel(dict);
%     for i = 1:numel(dict)
%         for j = 1:s2
%             coefSt{i}.dec{j} =  reshape(x(((j-1))*s1+1 + (i-1)*s1*s2 : j*s1 + (i-1)*s1*s2), n);
%         end
%         coef = coef + indwt2(coefSt{i});
%     end
end
% figure; imagesc(x); title(['RMSE: ' num2str(norm(x(:)-x2(:))/norm(x(:)))]);



















% 
% dict   = p.dict; % wavelet families used
% n      = p.n;    % size of the image
% N      = 1;   % I have only coded it for one level
% d      = p.d; % Dimension of the image
% 
% if ~isfield(p,'coefSt')
%     coefSt = [];
% else
%     coefSt = p.coefSt; % Structure of the wavelet coefficients
% end
% 
% 
% if k==0 % get the structure
%     for i = 1 : numel(dict)
%         coef{i} = ndwt2(randn(n),N,dict{i},'mode','per');
%         coef{i}.dec = [];
%     end
%     
% elseif k==1 % forward operator (image to wavelet coefficients)
%     coef = zeros([numel(dict)*d^2, n]);
%     for i = 1: numel(dict) 
%         coefTmp{i}= ndwt2(x,N,dict{i},'mode','per');
%         coef((i-1)*4+1,:,:) = 1/numel(dict)*coefTmp{i}.dec{1};
%         coef((i-1)*4+2,:,:) = 1/numel(dict)*coefTmp{i}.dec{2};
%         coef((i-1)*4+3,:,:) = 1/numel(dict)*coefTmp{i}.dec{3};
%         coef((i-1)*4+4,:,:) = 1/numel(dict)*coefTmp{i}.dec{4}; 
% %         figure; subplot(221); imagesc(coefTmp{i}.dec{1});
% %                 subplot(222); imagesc(coefTmp{i}.dec{2});
% %                 subplot(223); imagesc(coefTmp{i}.dec{3});
% %                 subplot(224); imagesc(coefTmp{i}.dec{4}); 
%     end
% 
% elseif k==-1 % backward operator (coefficients to image)
%     coef = zeros(n);
%     for i = 1:numel(dict);
%         coefSt{i}.dec{1} = squeeze(x((i-1)*4+1,:,:));
%         coefSt{i}.dec{2} = squeeze(x((i-1)*4+2,:,:));
%         coefSt{i}.dec{3} = squeeze(x((i-1)*4+3,:,:));
%         coefSt{i}.dec{4} = squeeze(x((i-1)*4+4,:,:));
%         coef = coef + indwt2(coefSt{i});
%     end
% end
% % figure; imagesc(x); title(['RMSE: ' num2str(norm(x(:)-x2(:))/norm(x(:)))]);
% 
% 
% 
